# fix_frozen_alphabet.py
with open("frozen_base4096_alphabet.txt", "r", encoding="utf-8") as f:
    raw = f.read()

# Remove all whitespace/newlines
cleaned = "".join(raw.split())

# Deduplicate but preserve order
seen = set()
alphabet = []
for ch in cleaned:
    if ch not in seen:
        seen.add(ch)
        alphabet.append(ch)

if len(alphabet) != 4096:
    raise ValueError(f"Alphabet still broken: {len(alphabet)} unique chars")

fixed = "".join(alphabet)

with open("frozen_base4096_alphabet.txt", "w", encoding="utf-8") as f:
    f.write(fixed)

print("✅ Fixed alphabet saved.")
print("Length:", len(fixed), "Unique:", len(set(fixed)))
